<?php
include '../../config.php';
include '../../jdf.php';

define('API_KEY',$API_KC);
$payment=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM payment LIMIT 1"));
$merichentziball=$payment['merichentziball'];

//----------------------------------------------
function factweb($method,$datas=[]){
    $url = "https://api.telegram.org/bot".API_KEY."/".$method;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$datas);
    $res = curl_exec($ch);
    if(curl_error($ch)){
        var_dump(curl_error($ch));
    }else{ 
        return json_decode($res);
    }
}

function postToZibal($path, $parameters)
{
    $url = 'https://gateway.zibal.ir/v1/'.$path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($parameters));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response  = curl_exec($ch);
    curl_close($ch);
    return json_decode($response);
}

// ------- Get Parameters -------
$trackId = $_GET['trackId'];
$success = $_GET['success'];
$order_code = $_GET['order'];

// بررسی وجود پارامترها
if(!$trackId || !$order_code){
    die("پارامترهای ورودی ناقص است");
}

// بررسی وجود سفارش و دریافت اطلاعات
$order_data = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM payment_orders WHERE order_code = '$order_code' LIMIT 1"));

if(!$order_data){
    die("سفارش یافت نشد");
}

// دریافت اطلاعات از سفارش
$user = $order_data['user_id'];
$amount = $order_data['amount'];

// بررسی وضعیت پرداخت از زیبال
if($success == '1'){
    // تایید پرداخت از زیبال
    $parameters = array(
        "merchant" => $merichentziball,//required
        "trackId" => $trackId,//required
    );

    $response = postToZibal('verify', $parameters);
    
    if ($response->result == 100) {
        // پرداخت موفق - بررسی اینکه قبلاً پردازش نشده باشد
        if($order_data['status'] == 'pending'){
            $sub_id = $order_data['subscription_id'];
            $sub_name = $order_data['subscription_name'];
            
            // دریافت اطلاعات اشتراک
            $sub_data = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM subscriptions WHERE id = '$sub_id' LIMIT 1"));
            
            if($sub_data){
                $days = $sub_data['days'];
                // تاریخ انقضا فقط با تاریخ (بدون ساعت و دقیقه)
                $expire_date = date('Y-m-d', strtotime("+$days days"));
                
                // فعال سازی اشتراک کاربر
                $connect->query("UPDATE user SET vip = 'yes', viptime = '$expire_date' WHERE id = '$user' LIMIT 1");
                
                // آپدیت وضعیت سفارش
                $connect->query("UPDATE payment_orders SET status = 'completed', completed_at = NOW() WHERE order_code = '$order_code' LIMIT 1");
                
                // ارسال پیام موفقیت به کاربر
                factweb('sendMessage',[
                    'chat_id'=>$user,
                    'text'=>"🎉 <b>پرداخت شما با موفقیت انجام شد!</b>

✅ اشتراک شما فعال شد.

📋 <b>جزئیات:</b>
🔢 <b>کد سفارش:</b> <code>$order_code</code>
🔢 <b>کد پیگیری:</b> <code>$trackId</code>
💰 <b>مبلغ:</b> " . number_format($amount) . " تومان
📅 <b>تاریخ انقضا:</b> " . jdate('Y/m/d', strtotime($expire_date)) . "

🎊 از خرید شما متشکریم!",
                    'parse_mode'=>"HTML"
                ]);
                
                // ارسال گزارش به کانال فیدبک
                factweb('sendMessage', [
                    'chat_id' => $channelfeedback,
                    'text' => "💰 <b>پرداخت موفق زیبال</b>

👤 <b>کاربر:</b> <a href='tg://openmessage?user_id=$user'>$user</a>
📋 <b>اشتراک:</b> $sub_name
💰 <b>مبلغ:</b> " . number_format($amount) . " تومان
🔢 <b>کد سفارش:</b> <code>$order_code</code>
🔢 <b>کد پیگیری:</b> <code>$trackId</code>
📅 <b>تاریخ:</b> " . date('Y-m-d H:i:s') . "

✅ <b>وضعیت:</b> تکمیل شده",
                    'parse_mode' => "HTML"
                ]);
                
                // صفحه موفقیت
                echo '
                <!DOCTYPE html>
                <html lang="fa" dir="rtl">
                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>پرداخت موفق</title>
                    <style>
                        @font-face {
                            font-family: "IRANYekanX";
                            src: url("../IRANYekanX-Bold.ttf") format("truetype");
                            font-weight: bold;
                            font-display: swap;
                        }
                        * {
                            margin: 0;
                            padding: 0;
                            box-sizing: border-box;
                        }
                        body {
                            display: flex;
                            justify-content: center;
                            align-items: center;
                            height: 100vh;
                            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                            font-family: "IRANYekanX", "Tahoma", Arial, sans-serif;
                        }
                        .message {
                            text-align: center;
                            background-color: #ffffff;
                            padding: 40px;
                            border-radius: 20px;
                            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
                            max-width: 500px;
                            width: 90%;
                        }
                        .success-icon {
                            font-size: 64px;
                            color: #28a745;
                            margin-bottom: 20px;
                        }
                        .success {
                            color: #28a745;
                            font-size: 24px;
                            font-weight: bold;
                            margin-bottom: 15px;
                        }
                        .details {
                            background-color: #f8f9fa;
                            padding: 20px;
                            border-radius: 10px;
                            margin: 20px 0;
                            text-align: right;
                        }
                        .detail-row {
                            display: flex;
                            justify-content: space-between;
                            margin-bottom: 10px;
                            padding: 5px 0;
                            border-bottom: 1px solid #dee2e6;
                        }
                        .detail-row:last-child {
                            border-bottom: none;
                        }
                        .detail-label {
                            font-weight: bold;
                            color: #495057;
                        }
                        .detail-value {
                            color: #007bff;
                        }
                        .link {
                            display: inline-block;
                            margin-top: 20px;
                            padding: 12px 30px;
                            background-color: #007BFF;
                            color: white;
                            text-decoration: none;
                            border-radius: 25px;
                            transition: background-color 0.3s;
                        }
                        .link:hover {
                            background-color: #0056b3;
                        }
                    </style>
                </head>
                <body>
                    <div class="message">
                        <div class="success-icon">✅</div>
                        <div class="success">پرداخت با موفقیت انجام شد</div>
                        <p>اشتراک شما فعال شد!</p>
                        
                        <div class="details">
                            <div class="detail-row">
                                <span class="detail-label">کد سفارش:</span>
                                <span class="detail-value">' . $order_code . '</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">کد پیگیری:</span>
                                <span class="detail-value">' . $trackId . '</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">مبلغ:</span>
                                <span class="detail-value">' . number_format($amount) . ' تومان</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">اشتراک:</span>
                                <span class="detail-value">' . $sub_name . '</span>
                            </div>
                        </div>
                        
                        <a href="https://t.me/' . $bottag . '" class="link">بازگشت به ربات</a>
                    </div>
                </body>
                </html>
                ';
                exit;
            }
        } else {
            // سفارش قبلاً پردازش شده
            echo '
            <!DOCTYPE html>
            <html lang="fa" dir="rtl">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>پرداخت تکراری</title>
                <style>
                    @font-face {
                        font-family: "IRANYekanX";
                        src: url("../IRANYekanX-Bold.ttf") format("truetype");
                        font-weight: bold;
                        font-display: swap;
                    }
                    body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        height: 100vh;
                        background-color: #f4f4f4;
                        font-family: "IRANYekanX", "Tahoma", Arial, sans-serif;
                    }
                    .message {
                        text-align: center;
                        background-color: #ffffff;
                        padding: 40px;
                        border-radius: 20px;
                        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                    }
                    .warning {
                        color: #ffc107;
                        font-size: 48px;
                        margin-bottom: 20px;
                    }
                    .title {
                        color: #856404;
                        font-size: 24px;
                        font-weight: bold;
                        margin-bottom: 15px;
                    }
                    .link {
                        display: inline-block;
                        margin-top: 20px;
                        padding: 12px 30px;
                        background-color: #007BFF;
                        color: white;
                        text-decoration: none;
                        border-radius: 25px;
                    }
                </style>
            </head>
            <body>
                <div class="message">
                    <div class="warning">⚠️</div>
                    <div class="title">این سفارش قبلاً پردازش شده است</div>
                    <p>پرداخت شما قبلاً انجام شده و اشتراک فعال است.</p>
                    <a href="https://t.me/' . $bottag . '" class="link">بازگشت به ربات</a>
                </div>
            </body>
            </html>
            ';
            exit;
        }
    } else {
        // پرداخت ناموفق
        $error_code = $response->result ?? 'نامشخص';
        $error_message = $response->message ?? 'خطا در تراکنش';
        
        factweb('sendMessage',[
            'chat_id'=>$user,
            'text'=>"❌ <b>پرداخت ناموفق</b>

🔢 <b>کد سفارش:</b> <code>$order_code</code>
⚠️ <b>علت:</b> $error_message (کد: $error_code)

💡 می‌توانید مجدداً تلاش کنید یا با پشتیبانی تماس بگیرید.",
            'parse_mode'=>"HTML"
        ]);
        
        echo '
        <!DOCTYPE html>
        <html lang="fa" dir="rtl">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>پرداخت ناموفق</title>
            <style>
                @font-face {
                    font-family: "IRANYekanX";
                    src: url("../IRANYekanX-Bold.ttf") format("truetype");
                    font-weight: bold;
                    font-display: swap;
                }
                body {
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                    background-color: #f4f4f4;
                    font-family: "IRANYekanX", "Tahoma", Arial, sans-serif;
                }
                .message {
                    text-align: center;
                    background-color: #ffffff;
                    padding: 40px;
                    border-radius: 20px;
                    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                }
                .error {
                    color: #dc3545;
                    font-size: 48px;
                    margin-bottom: 20px;
                }
                .title {
                    color: #721c24;
                    font-size: 24px;
                    font-weight: bold;
                    margin-bottom: 15px;
                }
                .link {
                    display: inline-block;
                    margin-top: 20px;
                    padding: 12px 30px;
                    background-color: #007BFF;
                    color: white;
                    text-decoration: none;
                    border-radius: 25px;
                }
            </style>
        </head>
        <body>
            <div class="message">
                <div class="error">❌</div>
                <div class="title">پرداخت ناموفق</div>
                <p>تراکنش شما تایید نشد. لطفاً مجدداً تلاش کنید.</p>
                <a href="https://t.me/' . $bottag . '" class="link">بازگشت به ربات</a>
            </div>
        </body>
        </html>
        ';
        exit;
    }
} else {
    // کاربر پرداخت را لغو کرده
    factweb('sendMessage',[
        'chat_id'=>$user,
        'text'=>"🚫 <b>پرداخت لغو شد</b>

🔢 <b>کد سفارش:</b> <code>$order_code</code>",
        'parse_mode'=>"HTML"
    ]);
    
    echo '
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>پرداخت لغو شد</title>
        <style>
            @font-face {
                font-family: "IRANYekanX";
                src: url("../IRANYekanX-Bold.ttf") format("truetype");
                font-weight: bold;
                font-display: swap;
            }
            body {
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                background-color: #f4f4f4;
                font-family: "IRANYekanX", "Tahoma", Arial, sans-serif;
            }
            .message {
                text-align: center;
                background-color: #ffffff;
                padding: 40px;
                border-radius: 20px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            }
            .cancel {
                color: #6c757d;
                font-size: 48px;
                margin-bottom: 20px;
            }
            .title {
                color: #495057;
                font-size: 24px;
                font-weight: bold;
                margin-bottom: 15px;
            }
            .link {
                display: inline-block;
                margin-top: 20px;
                padding: 12px 30px;
                background-color: #007BFF;
                color: white;
                text-decoration: none;
                border-radius: 25px;
            }
        </style>
    </head>
    <body>
        <div class="message">
            <div class="cancel">🚫</div>
            <div class="title">پرداخت لغو شد</div>
            <p>شما پرداخت را لغو کردید. می‌توانید هر زمان مجدداً تلاش کنید.</p>
            <a href="https://t.me/' . $bottag . '" class="link">بازگشت به ربات</a>
        </div>
    </body>
    </html>
    ';
    exit;
}
?>